	function PLOT_IMPULSE_RESPONSE_S(h, h0, t_axis)
	
	%	Plots the impulse response of a causal analog filter over the 
	%	time interval given by t_axis. The lower limit of t_axis is zero.	
	%	h0 is the value of the impulse ressponse at t = 0.
	
	% Toolbox for DIGITAL FILTERS USING MATLAB
 
	% Author: 			Lars Wanhammar 2006-02-27
	% Modified by: 	 	LW 2009-01-20, 2010-08-06
	% Copyright:		by authors - not released for commercial use
	% Version:			1
	% Known bugs: 
	% Report bugs to:	Wanhammar@gmail.com
	
	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================
 
	plot(t_axis, h,'linewidth',lw);
	axis([0 t_axis(end) min(h)-0.1 max(h)+0.1]); %  This may be changed to get a neater plot
	ylabel('{\ith}({\itt})','FontName', fn,'FontSize',fs);
	xlabel('{\itt}  [s]','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);
	hold on
	if (h0 ~= 0)
		plot([0 0],[h0 h0],'ro-', 'linewidth', 2)
	end 
	zoom on	
	grid on
	
	
